export type GreetingType = 'birthday' | 'anniversary' | 'first_order';
export type GreetingStatus = 'scheduled' | 'sent' | 'skipped' | 'failed';

export interface GreetingTemplate {
  id: string;
  vendor_id: string;
  type: GreetingType;
  message: string;
  send_time: string; // HH:mm
  created_at: string;
  updated_at: string;
}

export interface GreetingSchedule {
  id: string;
  vendor_id: string;
  birthday_enabled: boolean;
  anniversary_enabled: boolean;
  first_order_enabled: boolean;
  created_at: string;
  updated_at: string;
}

export interface GreetingLog {
  id: string;
  vendor_id: string;
  customer_id: string;
  type: GreetingType;
  status: GreetingStatus;
  message: string;
  scheduled_for: string;
  sent_at?: string;
  error?: string;
  created_at: string;
}

export interface CreateTemplateRequest {
  type: GreetingType;
  message: string;
  send_time: string;
}

export interface UpdateSettingsRequest {
  birthday_enabled?: boolean;
  anniversary_enabled?: boolean;
  first_order_enabled?: boolean;
} 